function  [spectre] = plot_spectrum(data, win ,fs,color_index)


if nargin<4
    color='b';
    linewidth=2;
else
     switch color_index
         case 0
           color=0;
       
         case 1
             color='b';
             linewidth=2;
         case 2
             color='r';
              linewidth=2;
         case 3
             color='g';
             linewidth=2;
         case 4
             color='k';
             linewidth=2;
                 
         case 5
             color='y';
              linewidth=2;
         
         case 6
             color='m';
              linewidth=2;
         
         case 7
             color='c';
                linewidth=2;
         
         case 8
             color='--b';
             linewidth=2;
         
         case 9
             color='--r';
              linewidth=2;
              
         case 10
             color='--g';
              linewidth=2;
         
         case 11
             color='b';
             linewidth=1;
         case 12
             color='r';
              linewidth=1;
         case 13
             color='g';
             linewidth=1;
         case 14
             color='black';
             linewidth=1;
                 
         case 15
             color='y';
              linewidth=1;
         
         case 16
             color='m';
              linewidth=1;
         
         case 17
             color='c';
                linewidth=1;
         
         case 18
             color='--b';
             linewidth=1;
         
         case 19
             color='--r';
              linewidth=1;
              
         case 20
             color='--g';
              linewidth=1;
          
         otherwise color='b';
     end
end
             
             
    
     [nb_lines,nb_col]=size(data);
     if (nb_lines>nb_col) data=data'; end % This part turn a column vector to a line vector
      
      N=(length(data));
      
      w = black(length(data));              %windowing
      U = (1/length(w))*sum(abs(w).^2);
      w=sqrt(2/U)*w/length(w);              %Window Normalization 
      spectre=abs(fft(data.*w')).^2;     %calculating the spectrum
     
    
    
 
    
     demi_spectre = spectre(1:floor((N/2+1)));
     
      
    
      
     
     
  if (color)   
      figure(win);
     
         if win<50
            plot((0:(fs/N):fs/2), 10*log10(demi_spectre),color,'lineWidth',linewidth);
    
        elseif ((win>50)&&(win<100))
             semilogx((0:(fs/N):fs/2), 10*log10(demi_spectre),color,'lineWidth',linewidth);  
        
    
        end
  end
    xlabel('f (Hz)','fontsize',24);
   ylabel('PSD (dB/bin)','fontsize',24);
      set(gca,'fontsize',24)

      
end