function [SNDR,PS]= perf_estim_mod(y,k,n,Bin_low,Bin_high)
% y is the time signal
% if pb>0 the signal is low pass, if not it is high pass
%k is the bin of the input signal, if  k=0  the function detects the maximum and considers it as the input 
%n number of points around the  peak 
% Bin_low is the bin of the lower frequency
% Bin_high is the bin of the upper frequency


%SNDR is signal to noise and distortions ratio
%PS is the signal power


    size_y= size(y);
    if size_y(1)>1 
        y=y';
    end           %putting the vector as lign vector if it is a column vector
    

  
   N=(length(y));
   w = black(N);                                         %windowing
   U = (1/N)*sum(abs(w).^2);
   w= (1/((N*U)^(1/2)))*w'*sqrt(3.504957918618154);      %Window Normalization 
    
   
   
  tfy=fft(w.*y)/sqrt(N);
 
  
  Ptfy=tfy.*conj(tfy);


  if (k==0)
    [~,k]=max(abs(Ptfy)); 

  end

  lim_low=max(k-n,3);
  lim_max=min(k+n,Bin_high);
  PS=sum(Ptfy(lim_low:lim_max));  %signal power calculation
 
  PND=sum(Ptfy(Bin_low:Bin_high))-PS;          %noise and distortions calculations
  SNDR=10*log10(PS/PND);
 



end
