
close all


N=2^18;  %Number of signal points
BW=10e6; %Signal bandwidth
Fs=20e9; %sampling frequency
Ts=1/Fs; %sampling period 



fin_or1=0.3e9 %Input sine frequency
Bin_in1=round(fin_or1/Fs*N); %Determining the input bin
fin1=Bin_in1*Fs/N;%
fin_or2=0.3e9 %Input sine frequency
Bin_in2=round(fin_or2/Fs*N); %Determining the input bin
fin2=Bin_in2*Fs/N;%
R=50;             %Matching impedance chosen equal to 50

K=1.38e-23; %Boltzmann Constant
T=290;      %room temperature
AntennaNoise=randn(1,N)*sqrt(K*T*BW*R);
t=0:Ts:(N-1)*Ts; %Time vetor  
f=0:Fs/N:Fs/2-Fs/N; %Frequency vector



Ga=6; %Gain of the first stage in dB
NFa=0; %Noise figure of the first stage in dB
IIP3a=-20; %IIP3 in dBm





Pin_spec1=-30;
Ain_spec1=sqrt(10.^((Pin_spec1-30)/10)*2*R);
SNR=zeros(1,length(Ain_spec1));
in=Ain_spec1*sin(2*pi*fin1*t+rand()*180)+Ain_spec1*sin(2*pi*fin2*t+rand()*180)+AntennaNoise; %Input signal
out=Amplifier(in,Ga,NFa,BW,IIP3a,R);                %output Signal
plot_spectrum(out*sqrt(1000/R),1,[Fs]);
hold on
plot_spectrum(in*sqrt(1000/R),1,[Fs],2);
legend('Amplifier Output','Amplifier Input')
title(['spectrum for Pin=',num2str(Pin_spec1),' dBm'])
xlabel('frequency(Hz)')
ylabel('PSD(dBm/bin)')

figure(2)
plot(t(1:500),in(1:500),'linewidth',2);
hold on
plot(t(1:500),out(1:500),'linewidth',2);
legend('Amplifier Output','Amplifier Input')
title('Time Domain signal')
xlabel('time(s)')
ylabel('Amplitude(V)')


