
close all


N=2^16;  %Number of signal points
BW=10e6; %Signal bandwidth
Fs=20e6; %sampling frequency
Ts=1/Fs; %sampling period 

fin_or=1.1e6; %Input sine frequenct
Bin_in=round(fin_or/Fs*N); %Determining the input bin
fin=Bin_in*Fs/N;%
K=1.38e-23; %Boltzmann Constant
T=290;      %room temperature
t=0:Ts:(N-1)*Ts; %Time vetor  
f=0:Fs/N:Fs/2-Fs/N; %Frequency vector
R=50; %Matching impedance chosen equal to 50
Pin=-80:2:-40;  %Pin in dBm
Ain=sqrt(10.^((Pin-30)/10)*2*R);
AntennaNoise=randn(1,N)*sqrt(K*T*BW*R);

Ga=6; %Gain of the first stage in dB
NFa=2.3; %Noise figure of the first stage in dB
IIP3a=-30; %IIP3 in dBm
SNR=zeros(1,length(Ain));
for i=1:length(Pin)
    in=Ain(i)*sin(2*pi*fin*t+rand()*180)+AntennaNoise; %Input signal
    out_amp=Amplifier(in,Ga,NFa,BW,IIP3a,R);            %output Signal
    SNR(i)=perf_estim(out_amp,1,Bin_in,5,1);   
end
plot(Pin,SNR)
xlabel('Pin(dbm)')
ylabel('SNDR(dB)')


Pin_spec1=-50;
Ain_spec1=sqrt(10.^((Pin_spec1-30)/10)*2*R);
in=Ain_spec1*sin(2*pi*fin*t+rand()*180)+AntennaNoise; %Input signal
out_spec1=Amplifier(in,Ga,NFa,BW,IIP3a,R);                %output Signal
plot_spectrum(out_spec1*sqrt(1000/R),2,[Fs]);
title('spetrum for Pin=-50 dBm')
xlabel('frequency(Hz)')
ylabel('PSD(dBm/bin)')

Pin_spec2=-55;
Ain_spec2=sqrt(10.^((Pin_spec2-30)/10)*2*R);
in=Ain_spec2*sin(2*pi*fin*t+rand()*180)+AntennaNoise; %Input signal
out_spec2=Amplifier(in,Ga,NFa,BW,IIP3a,R);                 %output Signal
plot_spectrum(out_spec2*sqrt(1000/R),3,[Fs]);
title('spetrum for Pin=-55 dBm')
xlabel('frequency(Hz)')
ylabel('PSD(dBm/bin)')
