
close all

N=2^16;  %Number of signal points
BW=10e6; %Signal bandwidth
Fs=20e6; %sampling frequency
Ts=1/Fs; %sampling period 

fin_or=1.1e6; %Input sine frequenct
Bin_in=round(fin_or/Fs*N); %Determining the input bin
fin=Bin_in*Fs/N;%
K=1.38e-23; %Boltzmann Constant
T=290;      %room temperature
t=0:Ts:(N-1)*Ts; %Time vetor  
f=0:Fs/N:Fs/2-Fs/N; %Frequency vector
R=50;  %Matching impedance chosen equal to 50
Pin=-50;  %Pin in dBm
Ain=sqrt(10.^((Pin-30)/10)*2*R);

AntennaNoise=randn(1,N)*sqrt(K*T*BW);
in=Ain*sin(2*pi*fin*t+rand()*180)+AntennaNoise; %Input signal
Ga=6; %Gain of the first stage in dB
Gb=12; %Gain of the second stage in dB
Gc=20; %Gain of the third stage in dB
NFa=2.3; %Noise figure of the first stage in dB
NFb=3; %Noise figure of the second stage in dB
NFc=6; %Noise figure of the third stage in dB
IIP3a=-30; %IIP3 of the first stage in dBm
IIP3b=-25;   %IIP3 of the second stage in dBm
IIP3c=-20;  %IIP3 of the third stage in dBm 


out1=Amplifier(in,Ga,NFa,BW,IIP3a,R);
out2=Amplifier(out1,Gb,NFb,BW,IIP3b,R);
out3=Amplifier(out2,Gc,NFc,BW,IIP3c,R);

figure(1)
subplot(2,2,1)
plot_spectrum(in*sqrt(1e3/R),1,[ 20e6]);
xlabel('frequency(Hz)')
ylabel('PSD(dBm/bin)')
title('input signal')


subplot(2,2,2)
plot_spectrum(out1*sqrt(1e3/R),1,[ 20e6],2);
xlabel('frequency(Hz)')
ylabel('PSD(dBm/bin)')
title('output of the first amplifier')

subplot(2,2,3)
plot_spectrum(out2*sqrt(1e3/R),1,[ 20e6],3);
xlabel('frequency(Hz)')
ylabel('PSD(dBm/bin)')
title('output of the second amplifier');

subplot(2,2,4)
plot_spectrum(out3*sqrt(1e3/R),1,[ 20e6],4);
xlabel('frequency(Hz)')
ylabel('PSD(dBm/bin)')
title('output of the third amplifier');



%

SNR_in=perf_estim(in,1,Bin_in,5,1);
SNR1=perf_estim(out1,1,Bin_in,5,1);
SNR2=perf_estim(out2,1,Bin_in,5,1);
SNR3=perf_estim(out3,1,Bin_in,5,1);

disp(['The SNR at the input is ',num2str(SNR_in),' dB'])
disp(['The SNR at the output of the first stage is ',num2str(SNR1), ' dB'])
disp(['The SNR at the output of the second stage is ',num2str(SNR2), ' dB'])
disp(['The SNR at the output of the third stage is ',num2str(SNR3),' dB'])
disp(['The overall Noise Figure ',num2str(SNR_in-SNR3),' dB'])


