function  out = Amplifier(in, Gain,NF,BW,IIP3,R)
K=1.38e-23; %Boltzmann Constant
T=290;      %room temperature
alpha3=-4/(10.^((IIP3-30+10*log10(R))/10));
AntennaNoise=randn(1,length(in))*sqrt(K*T*BW*R);
AddedNoise=sqrt(10.^(NF/10)-1)*AntennaNoise;
out=10.^(Gain/20)*(in+AddedNoise)+alpha3*(in+AddedNoise).^3;
end
