close all

Fcont=1e9; %Frequency to emulate the continuous time behavior

% Evaluate magnitude response of the filter
Fcut = 10e6; %3 dB Cut Frequency
order= 6; % Filter order
N=1e4;    %number of points
f=Fcont/2/N:Fcont/2/N:Fcont/2;


[b_butter,a_butter]=butter(order,Fcut/(Fcont/2));
[b_cheby2,a_cheby2]=cheby2(order,50,1.4*Fcut/(Fcont/2));
[b_ellip,a_ellip] = ellip(order,3,3,Fcut/(Fcont/2));

TF_butter=freqz(b_butter,a_butter,N);
TF_cheby2=freqz(b_cheby2,a_cheby2,N);
TF_ellip=freqz(b_ellip,a_ellip,N);

semilogx(f,20*log10(abs(TF_butter)))
hold all
semilogx(f,20*log10(abs(TF_cheby2)))
semilogx(f,20*log10(abs(TF_ellip)))

xlabel("Frequency (Hz)",'fontsize',20)
ylabel("Gain(dB)",'fontsize',20)
set(gca,'fontsize',20)
legend( "Butterworth","Chebyshev II", "Elliptic");

axis([1e5,200e6,-200,1])