close all
clear all

Fcont=1e9; %Frequency to emulate the behavior of a continuous time system
N=1e4;    %number of points
f1=5e6; %Low frequency - Useful Bandwidth limit
f2=15e6; %High Frequency - Stop Frequency
Amin=10; %Min attenuation at f2 in dB
Amax=2;  %Max attenuation at f1 in dB
f=Fcont/2/N:Fcont/2/N:Fcont/2;

[Order,Fcut_norm] = buttord(f1/(Fcont/2),f2/(Fcont/2),Amax,Amin);
Fcut=Fcut_norm*Fcont/2;

[b_butter,a_butter]=butter(Order,Fcut/(Fcont/2));
TF_butter=freqz(b_butter,a_butter,N);

semilogx(f,20*log10(abs(TF_butter)))
xlabel("Frequency (Hz)",'fontsize',20)
ylabel("Gain(dB)",'fontsize',20)
set(gca,'fontsize',20)
axis([1e5,200e6,-200,1])

disp(['The filter order is ',int2str(Order),' and the Fcut is ', num2str(Fcut/1e6),' MHz'])
