close all;
clear all;

%%VGA Specifications%%%
Gain_VGA=25;
IIP3_VGA=100;
NF_VGA=5;

%%ADC Specifications%%%
Nbits_ADC=10;
Vref_ADC=1;
FsADC=40e6;


%%General%%%
Fcont=1e9; %Operating Frequency to emulate the behavior of a continuous time system
Ts=1/Fcont; %sampling period 
Subsamp_fac=round(Fcont/FsADC);
N=2^13*Subsamp_fac;  %Number of signal points
BW=10e6; %Signal bandwidth
K=1.38e-23; %Boltzmann Constant
T=290;      %room temperature
t=0:Ts:(N-1)*Ts; %Time vetor  
f=0:Fcont/N:Fcont/2-Fcont/N; %Frequency vector
R=50;  %Matching impedance chosen equal to 50
AntennaNoise=randn(1,N)*sqrt(K*T*BW);




%%Filter Specifications%%%
NF_Filter=5; %Filter Noise Figure Filter
Fcut=50e6;   %Filter Fcut 3dB Frequency
Order=2;     %Filter Order
[b_butter,a_butter]=butter(Order,Fcut/(Fcont/2));





%%/Input Signal Specifications%%%%
fin_or=[7.1e6,20.3e6, 41e6];    %Input sine frequency
Bin_in=round(fin_or/Fcont*N); %Determining the input bin
fin=Bin_in*Fcont/N
Pin=[-60,-45 -40];            %Pin in dBm
Ain=sqrt(10.^((Pin-30)/10)*2*R);

%%/Input Signal Generation%%/
in=0;
for i=1:length(fin)
    in=in+Ain(i)*sin(2*pi*fin(i)*t+rand()*180);%Input signal
end
in=in+AntennaNoise;


Filter_out=Butt_Filter(in,b_butter,a_butter,NF_Filter,R,Fcont); %Filter
Amplifier_out=Amplifier(Filter_out,Gain_VGA,NF_VGA,BW,IIP3_VGA,R);%VGA
ADC_out=ADC(Amplifier_out(1:Subsamp_fac:N),Nbits_ADC,Vref_ADC);%ADC





figure(1)
subplot(2,2,1)
dessiner(in*sqrt(1e3/R),1, Fcont,1);
xlabel('frequency(Hz)')
ylabel('PSD(dBm/bin)')
title('Signal at the filter input')
axis([0,100e6,-200,1])

subplot(2,2,2)
dessiner(Filter_out*sqrt(1e3/R),1,Fcont,2);
xlabel('frequency(Hz)')
ylabel('PSD(dBm/bin)')
title('Signal at the filter output')
axis([0,100e6,-200,1])



subplot(2,2,3)
dessiner(Amplifier_out*sqrt(1e3/R),1,Fcont,3);
xlabel('frequency(Hz)')
ylabel('PSD(dBm/bin)')
title('output of the VGA')
axis([0,100e6,-200,1])

subplot(2,2,4)
dessiner(ADC_out*sqrt(1e3/R),1,FsADC,4);
xlabel('frequency(Hz)')
ylabel('PSD(dBm/bin)')
title('output of the ADC')
axis([0,FsADC/2,-200,1])

SNR_ADC=perf_estim(ADC_out,1,0,5,FsADC/(2*BW))

disp(['The maximum voltage at the filter output is ',num2str(max(Filter_out)),' V'])  
disp(['The SNR at the ADC output is ',num2str(SNR_ADC),'dB'])

