%%%% General filter specifications %%%%% 
%close all
Amin=20;
Amax=1;
f2=22.7e6;
f3=23.7e6;
f4=26e6;
f1=f3*f2/f4;
B=f3-f2;
%%% Omega-S%%%%
oms=(f4-f1)/(f3-f2);

D=sqrt((10^(Amin/10)-1)/(10^(Amax/10)-1));
n=ceil(log(D)/log(oms));

eps=sqrt(10^(Amax/10)-1); %%% configuration 1 eps max
%eps=sqrt((10^(Amin/10)-1)/oms^(2*n)); %%% configuration 2 eps min

%%%%%%%%%%%% S is the normalized Laplace variable %%%%%%%%%%%%
OMEGA=(1e-1:1e-1:500);
jOMEGA=1i*OMEGA; %%%  S=SIGMA + jOMEGA but to check the frequency behavior, we just kept the imaginary part
R=eps^(1/n);

%%%%%The following expression is valid only for a 2nd order filter%%%       
HLP_pro=1./(1+1.4141*jOMEGA*R+R.^2*jOMEGA.^2); %%% Low pass prototype filter

figure(1)
subplot(2,1,1)
semilogx(OMEGA,20*log10(abs(HLP_pro)),'linewidth',2)
hold all
title('Frequency response of the prototype filter')
xlabel('Normalized Frequency ','FontSize',25);
ylabel('Gain(dB)','FontSize',25);
set(gca,'fontsize',25)
subplot(2,1,2)
semilogx(OMEGA,20*log10(abs(HLP_pro)),'linewidth',2)
hold all
axis([0.1 1  -2 1])
title('zoom on the useful band')
xlabel('Normalized Frequency','FontSize',25);
ylabel('Gain(dB)','FontSize',25);
set(gca,'fontsize',25)



f=1e3:1e3:50e6;
jw=1i*2*pi*f;
w0=2*pi*sqrt(f2*f3);
Q=w0/B/2/pi;
jwpb=Q.*(jw/w0 + w0./jw);
%%%%%2nd order filter%%%
Hpb=1./(1+1.4141*jwpb*R+R.^2*jwpb.^2);
%Hpbor=2.12e16*jw.^2./(182.92*jw.^4+2.8056e9*jw.^3+7.79e18*jw.^2+5.958e25*jw+8.25e34);

figure(2)
subplot(2,1,1)
plot(f,20*log10(abs(Hpb)),'linewidth',2)
hold all
axis([0e6 50e6  -100 5])
title('Frequency response of the band pass filter')
xlabel('Frequency (Hz)','FontSize',25);
ylabel('Gain(dB)','FontSize',25);
set(gca,'fontsize',25)
subplot(2,1,2)
plot(f,20*log10(abs(Hpb)),'linewidth',2)
hold all
axis([0.9*f2 1.1*f3  -5 1])
title('zoom on the useful band')
xlabel('Frequency (Hz)','FontSize',25);
ylabel('Gain(dB)','FontSize',25);
set(gca,'fontsize',25)


display(["The low pass prototype filter order is ", num2str(n)]);
display(["The attenuation at the normalized pulstaion 1 is ", num2str(20*log10(abs(HLP_pro(OMEGA==1)))), " dB"]);
display(["The attenuation at the normalized puslation oms  ", num2str(20*log10(abs(HLP_pro(OMEGA==ceil(oms*10)/10)))), " dB"]);
display(["\n\n\nThe band pass filter order is ", num2str(2*n)]);
display(["The central frequency of the band pass filter is ", num2str(w0/2/pi/1e6), " MHz "]);
display(["The attenuation at the frequency 23.7 MHz is ", num2str(20*log10(abs(Hpb(f==f3)))), " dB"]);
display(["The attenuation at the frequency 26 MHz is ", num2str(20*log10(abs(Hpb(f==f4)))), " dB"]);