close all;
f=1:10e3:10000e6;   
jw=2*pi*f*1i; 
gm1=145e-3;
gm2=145e-3;
gm3=1000e-3;
C1=1e-9;
C2=1e-9;
w0=sqrt(gm1*gm2/C1/C2);
Q=1/gm3*sqrt(gm1*gm2*C2/C1);
num1=gm1*gm2;
num3=gm3*C1*jw;
num2=C1*C2*jw.^2;
denum=C1*C2*jw.^2+gm3*C1*jw+gm1*gm2;
H1=num1./denum; %%input V1
H2=num2./denum; %%input V2
H3=num3./denum; %%input V3

semilogx(f,20*log10(abs(H1)),'linewidth',2)
hold all
semilogx(f,20*log10(abs(H2)),'linewidth',2)
semilogx(f,20*log10(abs(H3)),'linewidth',2)

set(gca,'fontsize',25)
xlabel('frequency (Hz)')
ylabel( 'Gain (dB)')
legend('H1', 'H2','H3','location','southeast')
hold all
%% 
display(["The central frequency of the band pass filter is ", num2str(w0/2/pi/1e6), " MHz "]);
